﻿using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace ProxyDemo
{
    /// <summary>
    /// Obiekt proxy zapewniający komunikację z serwerem
    /// </summary>
    class MoneyTalkProxy : IDisposable
    {
        bool m_disposed;

        const int StreamSize = 256;
        const int Port = 2010;
        const string LocalHost = "localhost";
        IPEndPoint ipEndPt = new IPEndPoint(
            new IPAddress(
                new byte[] { 127, 0, 0, 1 }),
            Port);
        ASCIIEncoding AsciiEnc = new ASCIIEncoding();
        byte[] inStreamBytes = new byte[StreamSize];
        byte[] outStreamBytes = new byte[StreamSize];
        TcpClient myClient = new TcpClient(LocalHost, Port);
        Stream myStream;

        public MoneyTalkProxy()
        {
            myStream = myClient.GetStream();
            outStreamBytes = AsciiEnc.GetBytes(
                "Podaj sekret na zbicie fortuny:");
        }
        public string GetAdvice()
        {
            myStream.Write(
                outStreamBytes, 0, outStreamBytes.Length);

            // clean garbage chars from byte array
            for (int i = 0; i < inStreamBytes.Length; i++)
            {
                inStreamBytes[i] = 0;
            }

            // retrieve response from server
            myStream.Read(
                inStreamBytes, 0, inStreamBytes.Length);
            var freeAdvice = AsciiEnc.GetString(
                inStreamBytes, 0, inStreamBytes.Length);

            return freeAdvice;
        }

        public void Close()
        {
            Dispose();
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected void Dispose(bool disposing)
        {
            if (!m_disposed)
            {
                if (disposing)
                {
                    // close session with server
                    outStreamBytes = AsciiEnc.GetBytes("bye");
                    myStream.Write(
                        outStreamBytes, 0, outStreamBytes.Length);
                }
                else
                {
                    throw new InvalidOperationException(
                        "W aplikacji klienta zapomniano wywołać Dispose() - " +
                        "połączenie z serwerem nie zostało zakończone poprawnie!");
                }

                m_disposed = true;
            }
        }

        ~MoneyTalkProxy()
        {
            Dispose(false);
        }
    }
}
